/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonMapReader;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.json.JsonWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;

public class JsonObjectWrapper
extends JsonWrapper {
    private final JsonObject json;

    public JsonObjectWrapper(JsonObject json, JsonPath path) {
        super(path);
        this.json = json;
    }

    public Result<JsonElementWrapper, Failure> get(String key) {
        JsonPath newPath = this.path.thenObject(key);
        JsonElement element = this.json.get(key);
        if (element == null) {
            return Result.failure(newPath.expectedToExist());
        }
        return Result.success(new JsonElementWrapper(element, newPath));
    }

    public Result<JsonObjectWrapper, Failure> getObject(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an object")).andThen(JsonElementWrapper::getAsObject);
    }

    public Result<JsonArrayWrapper, Failure> getArray(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an array")).andThen(JsonElementWrapper::getAsArray);
    }

    public Result<String, Failure> getString(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a string")).andThen(JsonElementWrapper::getAsString);
    }

    public Result<Float, Failure> getFloat(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a float")).andThen(JsonElementWrapper::getAsFloat);
    }

    public Result<Double, Failure> getDouble(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a double")).andThen(JsonElementWrapper::getAsDouble);
    }

    public Result<Integer, Failure> getInt(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an int")).andThen(JsonElementWrapper::getAsInt);
    }

    public Result<Boolean, Failure> getBoolean(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a boolean")).andThen(JsonElementWrapper::getAsBoolean);
    }

    public Stream<Map.Entry<String, JsonElementWrapper>> stream() {
        return this.json.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new JsonElementWrapper((JsonElement)entry.getValue(), this.path.thenObject((String)entry.getKey()))));
    }

    public <S, F> Result<Map<String, S>, Map<String, F>> getAsMap(JsonMapReader<S, F> reader) {
        HashMap successMap = new HashMap();
        HashMap failureMap = new HashMap();
        this.json.entrySet().forEach(entry -> ((Result)reader.apply((String)entry.getKey(), new JsonElementWrapper((JsonElement)entry.getValue(), this.path.thenObject((String)entry.getKey())))).peek(t -> successMap.put((String)entry.getKey(), t), t -> failureMap.put((String)entry.getKey(), t)));
        if (failureMap.isEmpty()) {
            return Result.success(successMap);
        }
        return Result.failure(failureMap);
    }

    public JsonObject getJson() {
        return this.json;
    }
}

